package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.api.enumeration.MessageCategoryTypeEnum;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.time.DateFormatUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@XmlRootElement(name = "Message")
public abstract class MessageTO implements Serializable {
	public static final long serialVersionUID = -5445747007234726972L;
	public static String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
	// 02 Nov 2017 @ 1529
	public static String MILITARY_DATE_PATTERN = "dd MMM yyyy @ HHmm";
	public static String MILITARY_DATE_PATTERN1 = "dd MMM yyyy @ HH";
	public static String MILITARY_DATE_PATTERN2 = "mm";

	private Long id;
	private MessageCategoryTypeEnum category;
	private String subject;
	private String body;
	private boolean attachment;
	private AttachmentsTO attachments;
	private Date sentDate;
	private Long senderId;
	private String senderName;
	private Long recipientId;
	private String recipientName;
	private String readReceipt;
	private String triageGroupName;
	private String proxySenderName;

	public MessageTO() {
	}

	public MessageTO(long id, MessageCategoryTypeEnum category, String subject, String body, boolean attachment, AttachmentsTO attachments,
			Long senderId, String senderName, Long recipientId, String recipientName, Date sentDate, String readReceipt) {
		this.id = id;
		this.category = category;
		this.subject = subject;
		this.body = body;
		this.attachment = attachment;
		this.attachments = attachments;
		this.senderId = senderId;
		this.senderName = senderName;
		this.recipientId = recipientId;
		this.recipientName = recipientName;
		this.sentDate = sentDate;
		this.readReceipt = readReceipt;
	}
	
	public MessageTO(long id, MessageCategoryTypeEnum category, String subject, String body, boolean attachment, AttachmentsTO attachments,
			Long senderId, String senderName, Long recipientId, String recipientName, Date sentDate, String readReceipt, String proxySenderName) {
		this.id = id;
		this.category = category;
		this.subject = subject;
		this.body = body;
		this.attachment = attachment;
		this.attachments = attachments;
		this.senderId = senderId;
		this.senderName = senderName;
		this.recipientId = recipientId;
		this.recipientName = recipientName;
		this.sentDate = sentDate;
		this.readReceipt = readReceipt;
		this.proxySenderName = proxySenderName;
	}

	public MessageTO(long id, MessageCategoryTypeEnum category, String subject, String triageGroupName,
			String body, boolean attachment, AttachmentsTO attachments, Long senderId, String senderName, Long recipientId, String recipientName, Date sentDate, String readReceipt) {
		this.id = id;
		this.category = category;
		this.subject = subject;
		this.triageGroupName = triageGroupName;
		this.body = body;
		this.attachment = attachment;
		this.attachments = attachments;
		this.senderId = senderId;
		this.senderName = senderName;
		this.recipientId = recipientId;
		this.recipientName = recipientName;
		this.sentDate = sentDate;
		this.readReceipt = readReceipt;
	}

	public MessageTO(long id, MessageCategoryTypeEnum category, String subject, String triageGroupName,
			String body, boolean attachment, AttachmentsTO attachments, Long senderId, String senderName, Long recipientId, String recipientName, Date sentDate, String readReceipt, String proxySenderName) {
		this.id = id;
		this.category = category;
		this.subject = subject;
		this.triageGroupName = triageGroupName;
		this.body = body;
		this.attachment = attachment;
		this.attachments = attachments;
		this.senderId = senderId;
		this.senderName = senderName;
		this.recipientId = recipientId;
		this.recipientName = recipientName;
		this.sentDate = sentDate;
		this.readReceipt = readReceipt;
		this.proxySenderName = proxySenderName;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public MessageCategoryTypeEnum getCategory() {
		return category;
	}

	public void setCategory(MessageCategoryTypeEnum category) {
		this.category = category;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public boolean isAttachment() {
		return attachment; 
	}

	public void setAttachment(boolean attachment) {
		this.attachment = attachment;
	}

	public AttachmentsTO getAttachments() {
		return attachments;
	}

	public void setAttachments(AttachmentsTO attachments) {
		this.attachments = attachments;
	}

	public Date getSentDate() {
		return sentDate;
	}

	@JsonIgnore
	public String getSentDateString() {
		// For DRAFT messages there is a null date
		// String sentD = sentDate!=null?DateFormatUtils.formatUTC(sentDate,
		// RFC1123_PATTERN):"";
		// return (sentDate!=null?DateFormatUtils.formatUTC(sentDate, MILITARY_DATE_PATTERN)+" ET":"");
		// return (sentDate!=null?DateUtils.formatDate(sentDate):"");

		String sentD = null;
		if (sentDate != null) {
			sentD = DateFormatUtils.format(sentDate, MILITARY_DATE_PATTERN1) 
					+ "<span class=\"usa-sr-only\">:</span>"
					+ DateFormatUtils.format(sentDate, MILITARY_DATE_PATTERN2) 
					+ " ET";
		}
		return sentD;

	}

	public void setSentDate(Date sentDate) {
		this.sentDate = sentDate;
	}

	public Long getSenderId() {
		return senderId;
	}

	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}

	public String getSenderName() {
		return senderName;
	}

	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public Long getRecipientId() {
		return recipientId;
	}

	public void setRecipientId(Long recipientId) {
		this.recipientId = recipientId;
	}

	public String getRecipientName() {
		return recipientName;
	}

	public void setRecipientName(String recipientName) {
		this.recipientName = recipientName;
	}

	public String getReadReceipt() {
		return readReceipt;
	}

	public void setReadReceipt(String readReceipt) {
		this.readReceipt = readReceipt;
	}
	
	public String getTriageGroupName() {
		return triageGroupName;
	}

	public void setTriageGroupName(String triageGroupName) {
		this.triageGroupName = triageGroupName;
	}
	
	public String getProxySenderName() {
		return proxySenderName;
	}

	public void setProxySenderName(String proxySenderName) {
		this.proxySenderName = proxySenderName;
	}
	
	public String toString() {
		return "id=" + id + ";category=" + category + ";subject=" + subject + ";body=" + body + ";attachment=" + attachment + ";attachments="
				+ attachments + ";sentDate=" + sentDate + ";senderId=" + senderId + ";senderName=" + senderName + ";recipientId=" + recipientId
				+ ";recipientName=" + recipientName + ";readReceipt=" + readReceipt + ";proxySenderName=" + proxySenderName ;
	}
	
	
}
